import { Toaster } from "@/components/ui/sonner";
import { TooltipProvider } from "@/components/ui/tooltip";
import NotFound from "@/pages/NotFound";
import { Route, Switch } from "wouter";
import ErrorBoundary from "./components/ErrorBoundary";
import { ThemeProvider } from "./contexts/ThemeContext";
import Home from "./pages/Home";
import Request from "./pages/Request";
import Payment from "./pages/Payment";
import PaymentResult from "./pages/PaymentResult";
import Track from "./pages/Track";
import Admin from "./pages/Admin";
import Dashboard from "./pages/Dashboard";

function Router() {
  return (
    <Switch>
      <Route path="/" component={Home} />
      <Route path="/request" component={Request} />
      <Route path="/payment/:id" component={Payment} />
      <Route path="/payment-result/:id" component={PaymentResult} />
      <Route path="/track" component={Track} />
      <Route path={"/admin"} component={Admin} />
      <Route path={"/dashboard"} component={Dashboard} />
      <Route path="/404" component={NotFound} />
      <Route component={NotFound} />
    </Switch>
  );
}

function App() {
  return (
    <ErrorBoundary>
      <ThemeProvider defaultTheme="light">
        <TooltipProvider>
          <Toaster />
          <Router />
        </TooltipProvider>
      </ThemeProvider>
    </ErrorBoundary>
  );
}

export default App;
