#!/usr/bin/env python3
from fpdf import FPDF
import os

class ArabicPDF(FPDF):
    def header(self):
        # Logo placeholder
        self.set_font('Arial', 'B', 20)
        self.cell(0, 10, 'iScore', 0, 1, 'C')
        self.ln(5)
    
    def footer(self):
        self.set_y(-15)
        self.set_font('Arial', 'I', 8)
        self.cell(0, 10, f'Page {self.page_no()}', 0, 0, 'C')

# Create PDF
pdf = ArabicPDF()
pdf.add_page()
pdf.set_font('Arial', '', 12)

# Title
pdf.set_font('Arial', 'B', 24)
pdf.cell(0, 15, 'iScore Credit Report Service', 0, 1, 'C')
pdf.ln(5)

# Introduction
pdf.set_font('Arial', 'B', 16)
pdf.cell(0, 10, 'What is a Credit Report?', 0, 1)
pdf.set_font('Arial', '', 12)
pdf.multi_cell(0, 8, 'A credit report is a comprehensive file containing all your financial and credit information, including loans, credit cards, banking facilities, and payment history. It helps you understand your complete credit standing.')
pdf.ln(3)

# Why do you need it?
pdf.set_font('Arial', 'B', 16)
pdf.cell(0, 10, 'Why Do You Need a Credit Report?', 0, 1)
pdf.set_font('Arial', '', 12)
benefits = [
    '- Know your complete credit status',
    '- Improve your chances of getting financing',
    '- Avoid banking surprises',
    '- Make smart financial decisions',
    '- Identify and fix errors in your credit history'
]
for benefit in benefits:
    pdf.cell(0, 8, benefit, 0, 1)
pdf.ln(3)

# How it works
pdf.set_font('Arial', 'B', 16)
pdf.cell(0, 10, 'How It Works', 0, 1)
pdf.set_font('Arial', '', 12)
steps = [
    '1. Fill in your personal information',
    '2. Upload a photo of your ID card',
    '3. Choose your preferred payment method',
    '4. Submit payment proof',
    '5. Receive your report within 24-48 hours via email'
]
for step in steps:
    pdf.cell(0, 8, step, 0, 1)
pdf.ln(3)

# Pricing
pdf.set_font('Arial', 'B', 16)
pdf.cell(0, 10, 'Pricing', 0, 1)
pdf.set_font('Arial', 'B', 14)
pdf.cell(0, 10, '180 EGP (60% discount)', 0, 1)
pdf.set_font('Arial', '', 10)
pdf.cell(0, 6, 'Regular price: 450 EGP', 0, 1)
pdf.ln(3)

# Payment Methods
pdf.set_font('Arial', 'B', 16)
pdf.cell(0, 10, 'Payment Methods', 0, 1)
pdf.set_font('Arial', '', 12)
methods = [
    '- Vodafone Cash',
    '- Credit/Debit Cards (Visa, Mastercard)',
    '- Direct Bank Transfer',
    '- Meeza Cards'
]
for method in methods:
    pdf.cell(0, 8, method, 0, 1)
pdf.ln(3)

# Security
pdf.set_font('Arial', 'B', 16)
pdf.cell(0, 10, 'Data Security & Privacy', 0, 1)
pdf.set_font('Arial', '', 12)
pdf.multi_cell(0, 8, 'All your data is protected and encrypted according to the highest security and privacy standards. Your data will not be shared with any third party. We comply with all Egyptian data protection regulations.')
pdf.ln(3)

# Contact
pdf.set_font('Arial', 'B', 16)
pdf.cell(0, 10, 'Contact Us', 0, 1)
pdf.set_font('Arial', '', 12)
pdf.cell(0, 8, 'Website: prosuitehub.com', 0, 1)
pdf.cell(0, 8, 'For inquiries: Use the chat widget on our website', 0, 1)

# Save PDF
output_path = '/home/ubuntu/iscore-website/client/public/iscore-guide.pdf'
os.makedirs(os.path.dirname(output_path), exist_ok=True)
pdf.output(output_path)
print(f"PDF created successfully at: {output_path}")
