CREATE TABLE `messages` (
	`id` int AUTO_INCREMENT NOT NULL,
	`requestId` int NOT NULL,
	`senderType` enum('user','admin') NOT NULL,
	`message` text NOT NULL,
	`isRead` boolean NOT NULL DEFAULT false,
	`createdAt` timestamp NOT NULL DEFAULT (now()),
	CONSTRAINT `messages_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `payment_methods` (
	`id` int AUTO_INCREMENT NOT NULL,
	`nameAr` varchar(255) NOT NULL,
	`nameEn` varchar(255) NOT NULL,
	`type` varchar(100) NOT NULL,
	`details` text NOT NULL,
	`imageUrl` text,
	`isActive` boolean NOT NULL DEFAULT true,
	`createdAt` timestamp NOT NULL DEFAULT (now()),
	`updatedAt` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `payment_methods_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `requests` (
	`id` int AUTO_INCREMENT NOT NULL,
	`language` varchar(10) NOT NULL,
	`idCardImageUrl` text NOT NULL,
	`motherName` varchar(255) NOT NULL,
	`idNumber` varchar(50) NOT NULL,
	`email` varchar(320) NOT NULL,
	`phoneNumber` varchar(50),
	`paymentMethod` varchar(100),
	`paymentDetails` text,
	`paymentProofUrl` text,
	`status` enum('pending_payment','payment_submitted','paid','completed','refunded') NOT NULL DEFAULT 'pending_payment',
	`verificationCode` varchar(20),
	`reportPdfUrl` text,
	`totalAmount` int NOT NULL DEFAULT 180,
	`createdAt` timestamp NOT NULL DEFAULT (now()),
	`updatedAt` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `requests_id` PRIMARY KEY(`id`)
);
