import { int, mysqlTable, timestamp, varchar } from "drizzle-orm/mysql-core";

/**
 * Statistics table for storing manual stats
 */
export const statistics = mysqlTable("statistics", {
  id: int("id").autoincrement().primaryKey(),
  totalRequests: int("totalRequests").default(0).notNull(),
  totalRevenue: int("totalRevenue").default(0).notNull(), // in EGP
  totalUsers: int("totalUsers").default(0).notNull(),
  updatedAt: timestamp("updatedAt").defaultNow().onUpdateNow().notNull(),
});

export type Statistics = typeof statistics.$inferSelect;
export type InsertStatistics = typeof statistics.$inferInsert;
