const { drizzle } = require("drizzle-orm/mysql2");
const { paymentMethods } = require("./drizzle/schema.ts");

const db = drizzle(process.env.DATABASE_URL);

async function seed() {
  console.log("Starting seed...");

  // Add default payment methods
  await db.insert(paymentMethods).values([
    {
      nameAr: "فودافون كاش",
      nameEn: "Vodafone Cash",
      type: "vodafone_cash",
      details: "رقم الموبايل: 01009685523",
      isActive: true,
    },
    {
      nameAr: "بطاقة ائتمان/خصم",
      nameEn: "Credit/Debit Card",
      type: "card",
      details: "رقم البطاقة: 4111 1111 1111 1111\nالاسم: iScore\nتاريخ الانتهاء: 12/25\nCVV: 123",
      isActive: true,
    },
    {
      nameAr: "تحويل بنكي",
      nameEn: "Bank Transfer",
      type: "bank_transfer",
      details: "اسم البنك: البنك الأهلي المصري\nرقم الحساب: 123456789\nاسم صاحب الحساب: iScore Services",
      isActive: true,
    },
  ]);

  console.log("Seed completed successfully!");
}

seed().catch((error) => {
  console.error("Seed failed:", error);
  process.exit(1);
});
