import { describe, expect, it } from "vitest";
import * as db from "./db";

describe("Coupon System", () => {
  it("should validate a correct coupon code", async () => {
    const result = await db.validateCoupon("WELCOME20");
    
    expect(result.valid).toBe(true);
    expect(result.coupon).toBeDefined();
    if (result.coupon) {
      expect(result.coupon.code).toBe("WELCOME20");
      expect(result.coupon.discountType).toBe("percentage");
      expect(result.coupon.discountValue).toBe(20);
    }
  });

  it("should reject an invalid coupon code", async () => {
    const result = await db.validateCoupon("INVALID_CODE");
    
    expect(result.valid).toBe(false);
    expect(result.message).toBe("كود الخصم غير صحيح");
  });

  it("should get all coupons", async () => {
    const coupons = await db.getAllCoupons();
    
    expect(Array.isArray(coupons)).toBe(true);
    expect(coupons.length).toBeGreaterThan(0);
  });
});
