import { describe, expect, it } from "vitest";
import { appRouter } from "./routers";
import type { TrpcContext } from "./_core/context";

function createTestContext(): TrpcContext {
  return {
    user: null,
    req: {
      protocol: "https",
      headers: {},
    } as TrpcContext["req"],
    res: {} as TrpcContext["res"],
  };
}

describe("review.create", () => {
  it("should create a review successfully", async () => {
    const ctx = createTestContext();
    const caller = appRouter.createCaller(ctx);

    const result = await caller.review.create({
      name: "أحمد محمد",
      rating: 5,
      comment: "خدمة ممتازة وسريعة",
    });

    expect(result).toEqual({ success: true });
  });

  it("should create a review without comment", async () => {
    const ctx = createTestContext();
    const caller = appRouter.createCaller(ctx);

    const result = await caller.review.create({
      name: "فاطمة علي",
      rating: 4,
    });

    expect(result).toEqual({ success: true });
  });
});

describe("review.getAll", () => {
  it("should return all reviews", async () => {
    const ctx = createTestContext();
    const caller = appRouter.createCaller(ctx);

    const reviews = await caller.review.getAll();

    expect(Array.isArray(reviews)).toBe(true);
  });
});
